<?php $__env->startPush('content'); ?>
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-md-6">
                <div class="box">
                    <div class="box-header with-border">
                        <h3 class="box-title">Investment Details</h3>
                    </div>
                    <!-- /.box-header -->
                    <div class="box-body">
                        <table class="table table-bordered">


                            <tr>
                                <td>User</td>
                                <td><?php echo e($transaction->user->name ?? 'N/A'); ?></td>
                            </tr>
                            <tr>
                                <td>Amount</td>
                                <td>$<?php echo e($transaction->amount); ?></td>
                            </tr>

                            <tr>
                                <td>Plan Name</td>
                                <td><?php echo e($plan->name); ?> Plan</td>
                            </tr>
                            <tr>
                                <td>Plan Price</td>
                                <td>$<?php echo e($plan->amount); ?></td>
                            </tr>

                            <tr>
                                <td>Plan Days</td>
                                <td><?php echo e($plan->duration); ?> Days</td>
                            </tr>

                            <tr>
                                <td>Plan Roi</td>
                                <td><?php echo e($plan->roi); ?>%</td>
                            </tr>

                            <tr>
                                <td>Plan Terms</td>
                                <td><?php echo e($plan->terms); ?></td>
                            </tr>

                            <tr>
                                <td>Copy Expert Name</td>
                                <td><?php echo e($currentCopyExpert); ?></td>
                            </tr>

                            <tr>
                                <td>Plan Commission</td>
                                <td><?php echo e($plan->commission); ?>%</td>
                            </tr>



                            <tr>
                                <td>Date</td>
                                <td><?php echo e($transaction->created_at); ?></td>
                            </tr>

                            <tr>
                                <td>Status</td>
                                <td><?php echo e($transaction->status); ?></td>
                            </tr>

                            <?php if($transaction->status != 'completed'): ?>
                                <tr>
                                    <td>Investment Status</td>
                                    <td>
                                        <form action="<?php echo e(route('admin.transactions.updateStatus', $transaction->id)); ?>"
                                            method="POST">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('PATCH'); ?>
                                            <div class="form-group">
                                                <select name="status" class="form-control">
                                                    <option value="processing"
                                                        <?php echo e($transaction->status == 'processing' ? 'selected' : ''); ?>>Select
                                                        Investment Status</option>

                                                    <?php if($transaction->status == 'active'): ?>
                                                        <option value="completed"
                                                            <?php echo e($transaction->status == 'completed' ? 'selected' : ''); ?>>
                                                            Mark as
                                                            Completed</option>

                                                        <option value="cancelled"
                                                            <?php echo e($transaction->status == 'cancelled' ? 'selected' : ''); ?>>
                                                            Cancelled
                                                            Investment</option>
                                                    <?php endif; ?>

                                                    <?php if($transaction->status == 'processing'): ?>
                                                        <option value="active"
                                                            <?php echo e($transaction->status == 'active' ? 'selected' : ''); ?>>
                                                            Activate Investment</option>

                                                        <option value="cancelled"
                                                            <?php echo e($transaction->status == 'cancelled' ? 'selected' : ''); ?>>
                                                            Cancelled
                                                            Investment</option>
                                                    <?php endif; ?>

                                                </select>
                                            </div>
                                            <button type="submit" class="btn btn-primary">Update Status</button>
                                        </form>
                                    </td>
                                </tr>
                            <?php else: ?>
                            <?php endif; ?>



                        </table>
                    </div>

                </div>
            </div>
        </div>
        <!-- /.box -->

    </section>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/user/Documents/Developement/blocktraderinvestments/resources/views/admin/transactions/show.blade.php ENDPATH**/ ?>